/*
 * Decompiled with CFR 0.152.
 */
package com.github.monun.survival.kommand.argument;

import com.github.monun.survival.kommand.KommandContext;
import com.github.monun.survival.kommand.argument.KommandArgument;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0003J\u001f\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u0018R$\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\n\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0007\"\u0004\b\u0013\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/github/monun/survival/kommand/argument/IntegerArgument;", "Lcom/github/monun/survival/kommand/argument/KommandArgument;", "", "()V", "value", "maximum", "getMaximum", "()I", "setMaximum", "(I)V", "minimum", "getMinimum", "setMinimum", "parseFailMessage", "", "getParseFailMessage", "()Ljava/lang/String;", "radix", "getRadix", "setRadix", "parse", "context", "Lcom/github/monun/survival/kommand/KommandContext;", "param", "(Lcom/github/monun/kommand/KommandContext;Ljava/lang/String;)Ljava/lang/Integer;", "kommand"})
public final class IntegerArgument
implements KommandArgument<Integer> {
    private int maximum = Integer.MAX_VALUE;
    private int minimum = Integer.MIN_VALUE;
    private int radix = 10;

    @Override
    @NotNull
    public String getParseFailMessage() {
        return "<argument> <-- " + this.minimum + " ~ " + this.maximum + " \uc0ac\uc774\uc758 \uc815\uc218(" + this.radix + "\uc9c4\uc218)\uac00 \uc544\ub2d9\ub2c8\ub2e4.";
    }

    public final int getMaximum() {
        return this.maximum;
    }

    public final void setMaximum(int value) {
        boolean bl = value >= this.minimum;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "maximum " + value + " was not more than minimum " + this.minimum + '.';
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        this.maximum = value;
    }

    public final int getMinimum() {
        return this.minimum;
    }

    public final void setMinimum(int value) {
        boolean bl = value <= this.maximum;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "minimum " + value + " was not less than maximum " + this.maximum + '.';
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        this.minimum = value;
    }

    public final int getRadix() {
        return this.radix;
    }

    public final void setRadix(int value) {
        int n = value;
        n = 2 <= n && 36 >= n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string2 = "radix " + value + " was not in valid range 2..36";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        this.radix = value;
    }

    @Override
    @Nullable
    public Integer parse(@NotNull KommandContext context, @NotNull String param) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        Integer n = StringsKt.toIntOrNull((String)param, (int)this.radix);
        return n != null ? Integer.valueOf(RangesKt.coerceIn((int)n, (int)this.minimum, (int)this.maximum)) : null;
    }

    @Override
    @NotNull
    public Collection<String> listSuggestion(@NotNull KommandContext context, @NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return KommandArgument.DefaultImpls.listSuggestion(this, context, target);
    }
}

